
markup.push({


// MARK: block

DeclickBlock:
{
	"+": "BlockTemplate",
	geNodeClass: "AHRADeclickNode",
    h4PresetsId: "DeclickPresets",
	gxLibraryIcon: "library.effect.generic",
	gxPopoverInfo: "DeclickPopover",
	gxLibraryDescription: "Remove clicks from audio",
	gxTitle: "Declick",
	axTitle: "De Click",
	gxChildViews:
	{
		sensitivity: {
			"+": "SliderView.blockFace.trackUnfilled",
			gxValueKey: "node.sensitivity",
			gxRangeMin: 3.0,
			gxRangeMax: 9.0,
			gxDefaultValue: 3.0,
			gxKeystrokeStepSize: 0.1,
			axTitle: "Threshold",
			axFormatter: "DBFormatter",
		},
		sensitivityLabel: {
			"+": "LabelView.centerx.foreColorTheme1.size11",
			gxFrameRect: "18,31,83,25",
			gxDefaultValue: "Threshold",
		},
		sensitivityReadout: {
			"+": "LabelView.centerx.blockReadout",
			gxFrameRect: "18,66,83,25",
			gxValueKey: "node.sensitivity",
			gxFormatter: "DBFormatter",
		},
	},
},

    
// MARK: popover
    
DeclickPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "Declick",
	axTitle: "De Click",
	gxCanDrawSubviewsIntoLayer: true,
	gxWantsLayer: true,
	gxLayout: [ "H:|-12-[self(284)]-12-|",	// sets popover width
				"V:|-12-[self]-12-|",
				"V:|-41-[group]-8-[presetsGroup]"
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		group: {
			"+": "GroupView",
			gxLayout: [
				"H:|-0-[self]-0-|",
				"H:|-12-[sensitivity]-12-|",
				"V:|-30-[sensitivity]-30-[infoIcon]-16-|",

				"V:[sensitivityLabel]-(-1)-[sensitivity]-(-2)-[lessLabel]&alignLeft",
				"V:[sensitivityReadout]-(-1)-[sensitivity]-(-2)-[moreLabel]&alignRight",
				
				"H:|-12-[infoIcon(16)]-8-[infoText]-11-|",

				"V:[infoIcon(16)]-(-15)-[infoText(16)]",
			],
			gxChildViews: {
				sensitivity: {
					"+": "SliderView",
					gxValueKey: "node.sensitivity",
					gxRangeMin: 3.0,
					gxRangeMax: 9.0,
					gxDefaultValue: 3.0,
					gxKeystrokeStepSize: 0.1,
					axTitle: "Threshold",
					axFormatter: "DBFormatter",
				},
				sensitivityLabel: labelView("Threshold"),
				sensitivityReadout: {
					"+": "ReadoutView",
					gxValueKey: "node.sensitivity",
					gxClickValue: 3.0,
					gxFormatter: "DBFormatter",
				},
				lessLabel: labelView("More sensitive", "foreColor3.size11"),
				moreLabel: labelView("Less sensitive", "foreColor3.right.size11"), // "Right", right aligned
				infoIcon: { "+": "InfoIcon" },
				infoText: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "Remove clicks and pops from audio."
				},
			}
		}
	}
},

    
})
